/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999-2019 ohD(Twitter:@xm6_original)
 *	Copyright (C) 2001-2019 Ryu Takegami (Twitter:@RyuTakegami)
 *	Copyright (C) 2021 GIMONS
 *
 *	[ tbs[fBXN Rg[(MB8877A) ]
 */

#ifndef _fdc_h_
#define _fdc_h_

/*
 *	萔`
 */
#define FDC_DRIVES			4			/* T|[ghCu */
#define FDC_MEDIAS			16			/* D77t@CɊ܂܂ő喇 */

#define FDC_ST_BUSY			0x01		/* BUSY */
#define FDC_ST_INDEX		0x02		/* INDEXz[o */
#define FDC_ST_DRQ			0x02		/* f[^v */
#define FDC_ST_TRACK00		0x04		/* gbN0 */
#define FDC_ST_LOSTDATA		0x04		/* f[^Xg */
#define FDC_ST_CRCERR		0x08		/* CRCG[ */
#define FDC_ST_SEEKERR		0x10		/* V[NG[ */
#define FDC_ST_RECNFND		0x10		/* ZN^s */
#define FDC_ST_HEADENG		0x20		/* wbht */
#define FDC_ST_RECTYPE		0x20		/* R[h^Cvُ */
#define FDC_ST_WRITEFAULT	0x20		/* ݎs */
#define FDC_ST_WRITEP		0x40		/* ݕی */
#define FDC_ST_NOTREADY		0x80		/* fBA} */

#define FDC_TYPE_NOTREADY	0			/* t@CȂ */
#define FDC_TYPE_2D			1			/* 2Dt@C}Eg */
#define FDC_TYPE_D77		2			/* D77t@C}Eg */
#define FDC_TYPE_VFD		3			/* VFDt@C}Eg */
#define FDC_TYPE_2DD		4			/* 2DDt@C}Eg */
#define FDC_TYPE_FDX		5			/* FDXt@C}Eg */

#define FDC_ACCESS_READY	0			/* ANZXȂ */
#define FDC_ACCESS_SEEK		1			/* V[NnANZX */
#define FDC_ACCESS_READ		2			/* ǂݍ݌nANZX */
#define FDC_ACCESS_WRITE	3			/* ݌nANZX */
#define FDC_ACCESS_NOTREADY	4			/* hCȕłĂȂ */

#define FDC_LOST_TIME		48			/* waitLOST DATA܂ł̎ */
#define FDD_ROTATION_TIME	200000		/* hCu] */

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
BOOL FASTCALL fdc_init(void);
										/*  */
void FASTCALL fdc_cleanup(void);
										/* N[Abv */
void FASTCALL fdc_reset(void);
										/* Zbg */
BOOL FASTCALL fdc_readb(WORD addr, BYTE *dat);
										/* ǂݏo */
BOOL FASTCALL fdc_writeb(WORD addr, BYTE dat);
										/*  */
BOOL FASTCALL fdc_save(int fileh);
										/* Z[u */
BOOL FASTCALL fdc_load(int fileh, int ver);
										/* [h */
int FASTCALL fdc_setdisk(int drive, char *fname);
										/* fBXNZbg */
BOOL FASTCALL fdc_setmedia(int drive, int index);
										/* fBXNt@CfBAw */
BOOL FASTCALL fdc_setwritep(int drive, BOOL writep);
										/* CgveNgw */

/*
 *	v[N
 */
extern BYTE fdc_command;
										/* $FD18 FDCR}h */
extern BYTE fdc_status;
										/* $FD18 FDCXe[^X */
extern BYTE fdc_trkreg;
										/* $FD19 gbNWX^ */
extern BYTE fdc_secreg;
										/* $FD1A ZN^WX^ */
extern BYTE fdc_datareg;
										/* $FD1B f[^WX^ */
extern BYTE fdc_sidereg;
										/* $FD1C TChWX^ */
extern BYTE fdc_motor;
										/* $FD1D [^(on:0x80 off:0x00) */
extern BYTE fdc_drvreg;
										/* $FD1D hCu(0-3) */
extern BYTE fdc_drqirq;
										/* $FD1F DRQ, IRQ, ̑tO */

#if XM7_VER >= 2
extern BYTE fdc_dsenable;
										/*($FD1D)DSCl[u */
#endif

#if XM7_VER >= 3
extern BYTE fdc_drvregP;
										/*($FD1D)hCuԍ */
extern BYTE fdc_logidrv;
										/* $FD1E _hCuԍ */
extern BYTE fdc_physdrv[FDC_DRIVES];
										/* $FD1E _/hCȗΉ */
extern BYTE fdc_2ddmode;
										/* $FD1E 2DD[hZNg */
#endif

extern BYTE fdc_cmdtype;
										/* R}h^Cv */
extern WORD fdc_totalcnt;
										/* g[^JE^ */
extern WORD fdc_nowcnt;
										/* JgJE^ */
extern BYTE fdc_ready[FDC_DRIVES];
										/* fB */
extern BOOL fdc_teject[FDC_DRIVES];
										/* ꎞCWFNg */
extern BOOL fdc_writep[FDC_DRIVES];
										/* ݋֎~ */
extern BYTE fdc_track[FDC_DRIVES];
										/* gbN */

extern char fdc_fname[FDC_DRIVES][256+1];
										/* t@Cl[ */
extern char fdc_name[FDC_DRIVES][FDC_MEDIAS][17];
										/* fBAƂ̖O */
extern BOOL fdc_fwritep[FDC_DRIVES];
										/* ݋֎~(t@CP) */
extern BYTE fdc_header[FDC_DRIVES][0x2b0];
										/* D77t@Cwb_ */
extern BYTE fdc_medias[FDC_DRIVES];
										/* fBA */
extern BYTE fdc_media[FDC_DRIVES];
										/* fBAZNg */
extern BYTE fdc_access[FDC_DRIVES];
										/* ANZXLED */

#ifdef FDDSND
extern BOOL fdc_waitmode;
										/* FDCANZXEFCg */
extern BOOL fdc_sound;
										/* FDDV[NtO */
#endif

/*
 *	FDXT|[g
 */
#define FDX_MAX_CYLINDER	84			/* őV_ */
#define FDX_MAX_HEADS		2			/* őwbh */
#define FDX_MAX_TRACK		168			/* őgbN */
#define FDX_MAX_SECTOR		96			/* őZN^ */
#define FDX_MAX_CELLS		0x4000		/* 16384 */
#define FDX_CELL_BITS		16			/* 1Z̃rbg */
#define FDX_ENC_BYTES		0x8000		/* GR[hf[^obt@TCY */
#define FDX_ENC_BITS		(FDX_ENC_BYTES * 8)
#define FDX_RAW_BYTES		0x40000		/* RAWf[^obt@TCY */
#define FDX_RAW_BITS		(FDX_RAW_BYTES * 8)
#define FDX_TYPE_2D			0			/* 2D */
#define FDX_TYPE_2DD		1			/* 2DD */
#define FDX_TYPE_2HD		2			/* 2HD */
#define FDX_TYPE_RAW		9			/* RAW */
#define FDX_ERR_MASK		0xff000000	/* G[}XN */
#define FDX_ERR_ICRC		0x40000000	/* CRCG[(ID) */
#define FDX_ERR_IINV		0x20000000	/* sG[(ID) */
#define FDX_ERR_DCRC		0x10000000	/* CRCG[(DATA) */
#define FDX_ERR_DINV		0x08000000	/* sG[(DATA) */
#define FDX_ERR_UNKN		0x01000000	/* ̓G[(̑) */
#define FDX_INF_MASK		0x00ff0000	/* }XN */
#define FDX_INF_ISTR		0x00800000	/* CfbNXׂ */
#define FDX_INF_MFM			0x00400000	/* MFMf[^ */
#define FDX_INF_FM			0x00200000	/* FMf[^ */
#define FDX_INF_IAM			0x00100000	/* IAM */
#define FDX_INF_SECMSK		0x000000ff	/* ZN^}XN */
#define FDX_FDD_NOERROR		0x0000		/* G[ */
#define FDX_FDD_DDAM		0x4000		/* DDAMZN^ */
#define FDX_FDD_DATAERR		0x2000		/* IDCRC܂̓f[^CRC(ReadID) */
#define FDX_FDD_IDCRC		0x0800		/* IDtB[hCRC */
#define FDX_FDD_DATACRC		0x0020		/* f[^CRC */
#define FDX_FDD_MDAM		0x0001		/* DAMȂ */
#define FDX_HDRBYTES		(4 * 4)

static const BYTE FDX_IAM_MFM[12] = {
	0xAA, 0xAA, 0xAA, 0xAA,			// $00$00̃GR[h
	0x52, 0x24, 0x52, 0x24,			// $C2$C2̃GR[h
	0x52, 0x24, 0x55, 0x52			// $C2$FC̃GR[h
};

static const BYTE FDX_IDAM_MFM[12] = {
	0xAA, 0xAA, 0xAA, 0xAA,			// $00$00̃GR[h
	0x44, 0x89, 0x44, 0x89,			// $A1$A1̃GR[h
	0x44, 0x89, 0x55, 0x54			// $A1$FẼGR[h
};

static const BYTE FDX_DAM_MFM[12] = {
	0xAA, 0xAA, 0xAA, 0xAA,			// $00$00̃GR[h
	0x44, 0x89, 0x44, 0x89,			// $A1$A1̃GR[h
	0x44, 0x89, 0x55, 0x45			// $A1$FB̃GR[h
};

static const BYTE FDX_DDAM_MFM[12] = {
	0xAA, 0xAA, 0xAA, 0xAA,			// $00$00̃GR[h
	0x44, 0x89, 0x44, 0x89,			// $A1$A1̃GR[h
	0x44, 0x89, 0x55, 0x4A			// $A1$F8̃GR[h
};

typedef struct {
	BYTE signature[3];					/* ʎq('F','D','X') */
	BYTE revision;						/* rW(3) */
	BYTE name[60];						/* fBXN */
	BYTE pad[4];						/* pfBO */
	int type;							/* ^Cv(0:2D 1:2DD 2:2HD 9:RAW) */
	int cylinders;						/* V_[ */
	int heads;							/* wbh */
	int rate;							/* ][g(NbN) */
	int rpm;							/* RPM */
	BOOL writeprotect;					/* CgveNg(0: OFF 1:ON) */
	DWORD option;						/* IvV */
	DWORD unused;						/* gp */
	int trackblk;						/* gbNubN(oCg) */
	BYTE reserve[152];					/* U[u(S256oCgɒ) */
} fdxheader_t;

typedef struct {
	int cylinder;						/* V_[ */
	int head;							/* wbh */
	int index;							/* CfbNXz[ʒu(rbg) */
	int length;							/* gbNf[^(rbg) */
	BYTE data[1];						/* f[^|C^ */
} fdxtrack_t;

typedef struct {
	DWORD chrn[4];						/* CHRN */
	int gap2;							/* GAP3TCY */
	int size;							/* f[^TCY */
	int gap3;							/* GAP3TCY */
	DWORD err;							/* G[R[h */
	BYTE *data;							/* fR[hf[^ */
	BYTE icrc[2];						/* ID CRC */
	BYTE dcrc[2];						/* DATA CRC */
	int idamoffset;						/* IDAMItZbg */
	int damoffset;						/* DAM/DDAMItZbg */
	int eosoffset;						/* ZN^ItZbg */
	BYTE *encdata;						/* GR[hf[^ */
	int enclen;							/* GR[hf[^ */
	int encratio;						/* GR[hf[^x */
} fdxsecstat_t;

typedef struct {
	DWORD status;						/* Xe[^X */
	BYTE *encbuf;						/* GR[hf[^ */
	int enclen;							/* GR[hf[^ */
	int num;							/* ZN^ */
	int iamoffset;						/* IAMItZbg */
	int gap1;							/* GAP1TCY */
	int gap4a;							/* GAP4aTCY */
	int gap4b;							/* GAP4bTCY */
	fdxsecstat_t sector[FDX_MAX_SECTOR];/* ZN^[f[^ */
} fdxtrkstat_t;

int FASTCALL fdx_fill_mfm(BYTE *dst, BYTE data, int size, BOOL *last);
int FASTCALL fdx_gen_mfm(BYTE *dst, BYTE *src, int size, BOOL *last);

#ifdef __cplusplus
}
#endif

#endif	/* _fdc_h_ */
